package gov.va.med.mhv.health.validator;

import gov.va.med.mhv.health.dto.AllergyDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import gov.va.med.mhv.health.enums.DiagnosedEnumeration;
import gov.va.med.mhv.health.enums.SeverityEnumeration;

import java.util.Date;

import org.springframework.stereotype.Component;

@Component
public class AllergyValidator extends Validator{
	
	private static final int COMMENTS_MAX_LENGTH = 255;
	private static final int ALLERGY_MIN_LENGTH = 2;
	private static final int ALLERGY_MAX_LENGTH = 50;
	private static final int REACTION_MAX_LENGTH = 255;
	private static final String USER_PROFILE="userProfile";
	private static final String SEVERITY="Severity";
	private static final String DIAGNOSED="Diagnosed";
	private static final String REACTION="Reaction";
	private static final String EVENT_DATE="Event Date";
	private static final String ALLERGY="Allergy";
	private static final String COMMENTS="Comments";
	
	
	
	
	public void allergyValidations(ResponseUtil response, AllergyDTO allergyDTO) {
		fieldValidation(response, allergyDTO);
	}

	private void fieldValidation(ResponseUtil response, AllergyDTO allergyDTO) {
		validateComments(response,allergyDTO);
		validateAllergy(response,allergyDTO);
		validateEventDate(response,allergyDTO);
		validateReaction(response,allergyDTO);
		validateDiagnosed(response,allergyDTO);
		validateSeverity(response,allergyDTO);
		validateUserProfile(response,allergyDTO);
	}

	private void validateUserProfile(ResponseUtil response,AllergyDTO allergyDTO) {
		if( allergyDTO.getUserprofileId() == null ) {
			response.getValidationErrors().put(USER_PROFILE, "userProfile is required");
			return;
		}
		boolean valid= isUserProfileValid(allergyDTO.getUserprofileId());
		if ( !valid) {
			response.getValidationErrors().put(USER_PROFILE, "userProfile is Invalid");
		}
	}

	private void validateSeverity(ResponseUtil response, AllergyDTO allergyDTO) {
		String value = allergyDTO.getSeverity();
		if( value == null  || value.trim().length() == 0 ) {
			return;
		}		
		Validations.validateEnumeration(SEVERITY, value, SeverityEnumeration.values(), response.getValidationErrors());
	}

	private void validateDiagnosed(ResponseUtil response, AllergyDTO allergyDTO) {
		
		String value = allergyDTO.getDiagnosed();
		if( value == null ) {
			return;
		}		
		Validations.validateEnumeration(DIAGNOSED, value, DiagnosedEnumeration.values(), response.getValidationErrors());
	}

	private void validateReaction(ResponseUtil response, AllergyDTO allergyDTO) {
		
		String value = allergyDTO.getReaction();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength(REACTION,value, REACTION_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateEventDate(ResponseUtil response, AllergyDTO allergyDTO) {
		
		Date value = allergyDTO.getEventDate();
		if( value == null ) {
			Validations.validateRequired(EVENT_DATE, value, response.getValidationErrors());
			return;
		}		
	}

	private void validateAllergy(ResponseUtil response, AllergyDTO allergyDTO) {
		String value = allergyDTO.getAllergy();
		if ( value == null ) {
			Validations.validateRequired(ALLERGY, value, response.getValidationErrors());
			return;
		}		
		Validations.validateMinLength(ALLERGY,value, ALLERGY_MIN_LENGTH, response.getValidationErrors());
		Validations.validateMaxLength(ALLERGY,value, ALLERGY_MAX_LENGTH, response.getValidationErrors());
	}

	private void validateComments(ResponseUtil response, AllergyDTO allergyDTO) {
		String value = allergyDTO.getComments();
		if ( value == null ) {
			return;
		}						
		Validations.validateMaxLength(COMMENTS,value, COMMENTS_MAX_LENGTH, response.getValidationErrors());
	}
}
